/*
 * Copyright (c) 2005, 2006, Oracle. All rights reserved.  
 */

import java.util.logging.LogManager;

import javax.jcr.Session;
import javax.jcr.SimpleCredentials;

import oracle.jcr.OracleRepository;
import oracle.jcr.OracleRepositoryFactory;

import oracle.jcr.xdb.XDBRepositoryConfiguration;

import oracle.jdbc.pool.OracleDataSource;

/**
 * Demonstrates how to create a JCR connection.
 */
public class Login
{
  /**
   * Entry point from command line.
   * 
   * @param args            command-line arguments
   * 
   * @throws Exception if the operation fails
   */
  public static void main(String[] args)
    throws Exception
  {
    // The XML DB Content Connector uses JDK logging.  To disable logging,
    // uncomment the following line.  For further information on JDK logging,
    // refer to:
    //   http://java.sun.com/j2se/1.4.2/docs/guide/util/logging/index.html.
    
    // LogManager.getLogManager().reset();

    // Extract the command-line arguments.
    if (args == null || args.length != 3)
    {
      System.out.println("Use: java Login <databaseURL> <userName> <password>");
      System.exit(-1);
    }
    
    String databaseURL = args[0];
    String userName = args[1];
    String password = args[2];
    
    // Create an uninitialized repository configuration.
    XDBRepositoryConfiguration repositoryConfiguration =
      new XDBRepositoryConfiguration();
    
    // Set the database URL.
    OracleDataSource dataSource = (OracleDataSource)repositoryConfiguration.getDataSource();
    dataSource.setURL(databaseURL);

    // Create a repository.
    OracleRepository repository =
      OracleRepositoryFactory.createOracleRepository(repositoryConfiguration);

    // Construct the credentials.
    SimpleCredentials credentials =
      new SimpleCredentials(userName, password.toCharArray());
      
    // Use the default workspace.
    String workspace = null;
    
    // Connect.
    Session session = repository.login(credentials, workspace);
    System.out.println("Connected as " + session.getUserID());
    
    // Disconnect.
    session.logout();
    System.out.println("Disconnected");
  }
}

// EOF
